/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CToolbar.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CToolbar_h	// [
#define Included_CToolbar_h

#include "pgpClassesConfig.h"
#include <commctrl.h>

#include "UMath.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CToolbar

class CToolbar : public CWindow
{
public:
	CToolbar() { }
	~CToolbar() { }

	PGPInt32	AddBitmap(PGPUInt32 numImages, TBADDBITMAP *pAddBitmap) const
	{
		return SendMessage(TB_ADDBITMAP, numImages, reinterpret_cast<LPARAM>(
			pAddBitmap));
	}

	PGPBoolean	AddButtons(PGPUInt32 numButtons, TBBUTTON *pButtons) const
	{
		return static_cast<PGPBoolean>(SendMessage(TB_ADDBUTTONS, 
			numButtons, reinterpret_cast<LPARAM>(pButtons)));
	}

	PGPInt32	AddString(HINSTANCE instance, const char *strings) const
	{
		return SendMessage(TB_ADDSTRING, reinterpret_cast<WPARAM>(instance), 
			reinterpret_cast<LPARAM>(strings));
	}

	void		AutoSize() const
	{
		SendMessage(TB_AUTOSIZE);
	}

	void		ButtonStructSize(PGPUInt32 structSize) const
	{
		SendMessage(TB_BUTTONSTRUCTSIZE, structSize);
	}

	PGPBoolean	EnableButton(PGPUInt32 buttonID, PGPBoolean enable) const
	{
		return static_cast<PGPBoolean>(SendMessage(TB_ENABLEBUTTON, 
			buttonID, enable));
	}

	void		GetButtonSize(PGPUInt16& width, PGPUInt16& height) const
	{
		PGPUInt32	result	= SendMessage(TB_GETBUTTONSIZE);

		width = UMath::GetLowWord(result);
		height = UMath::GetHighWord(result);
	}

	PGPBoolean	SetBitmapSize(PGPUInt16 xBitmap, PGPUInt16 yBitmap) const
	{
		return static_cast<PGPBoolean>(SendMessage(TB_SETBITMAPSIZE, 0, 
			UMath::MakeDWord(xBitmap, yBitmap)));
	}

	PGPBoolean	SetButtonSize(PGPUInt16 xButton, PGPUInt16 yButton) const
	{
		return static_cast<PGPBoolean>(SendMessage(TB_SETBUTTONSIZE, 0, 
			UMath::MakeDWord(xButton, yButton)));
	}

	PGPBoolean	SetButtonWidth(PGPUInt16 min, PGPUInt16 max) const
	{
		return static_cast<PGPBoolean>(SendMessage(TB_SETBUTTONWIDTH, 0, 
			UMath::MakeDWord(min, max)));
	}

	HIMAGELIST	SetDisabledImageList(HIMAGELIST imageList) const
	{
		return reinterpret_cast<HIMAGELIST>(
			SendMessage(TB_SETDISABLEDIMAGELIST, 0, 
			reinterpret_cast<LPARAM>(imageList)));
	}

	HIMAGELIST	SetHotImageList(HIMAGELIST imageList) const
	{
		return reinterpret_cast<HIMAGELIST>(
			SendMessage(TB_SETHOTIMAGELIST, 0, 
			reinterpret_cast<LPARAM>(imageList)));
	}

	HIMAGELIST	SetImageList(HIMAGELIST imageList) const
	{
		return reinterpret_cast<HIMAGELIST>(SendMessage(TB_SETIMAGELIST, 0, 
			reinterpret_cast<LPARAM>(imageList)));
	}
	
	void	Create(HWND parent, PGPUInt32 id, PGPUInt32 style, 
		PGPInt32 xOffset = 0, PGPInt32 yOffset = 0, PGPInt32 width = 0, 
		PGPInt32 height = 0);
};

_PGP_END

#endif	// ] Included_CToolbar_h
